require( "scripts/style.lua" )

-- Start the Comic Screen Timer
StartComicScreenTimer();

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

MakeDialog
{
	Bitmap
	{ 
		image="images/ComicPanel1Sketch.jpg",	
		x=kCenter,
		y=kCenter,
		
		-- advance to next page
		Button
		{
			x = kMax - 60,
			y = 550,
			font = StandardButtonFont,
			graphics = RightButtonGraphics,
			name="next",
			type = kPush,
			command=
				function()
					PopModal();
					DoModal("scripts/comic1b.lua");
				end
		};
		
		-- Only two days...
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=75, y=48,
			w=236,h=19,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_a",
		};
		
		-- Amy you look amazing...
		Text
		{
			font = { comicFont, 15, BlackColor };
			x=77, y=82,
			w=130,h=85,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_b",
		};
		
		-- Ooh that's the wedding...
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=404, y=40,
			w=128,h=35,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_c",
		};
		
		-- Pink is so not my...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=380, y=90,
			w=65,h=45,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_d",
		};
		
		-- RING!
		Text
		{
			font = { comicFont, 22, BlackColor };
			x=449, y=97,
			w=120,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_e",
		};
		
		-- It's over!...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=667, y=50,
			w=78,h=55,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_f",
		};
		
		-- Come on...
		Text
		{
			font = { comicFont, 16, BlackColor };
			x=658, y=255,
			w=85,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_g",
		};
		
		-- The florist quit...
		Text
		{
			font = { comicFont, 14, BlackColor };
			x=62, y=383,
			w=150,h=86,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_h",
		};
		
		-- Don't worry...
		Text
		{
			font = { comicFont, 16, BlackColor };
			x=258, y=381,
			w=90,h=65,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_i",
		};
		
		-- That's it!...
		Text
		{
			font = { comicFont, 20, BlackColor };
			x=532, y=360,
			w=135,h=102,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_1_1_j",
		};
	}
}

PlayComicMusic();



